import argparse
import json

from travel.rasp.crosslink.tools import data
from travel.rasp.crosslink.tools import db


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument("-d", "--database", default='/ru-prestable/railway/testing/train_purchase')
    parser.add_argument("-e", "--endpoint", default='ydb-ru-prestable.yandex.net:2135')
    parser.add_argument("-f", "--file", default='TRAVELANALYTICS-137_linking.csv')
    parser.add_argument("-v", "--graph_version", default=0)
    parser.add_argument("-t", "--token", required=True)
    group = parser.add_mutually_exclusive_group(required=True)
    group.add_argument('-tt', '--train', action='store_true')
    group.add_argument('-bt', '--bus', action='store_true')

    args = parser.parse_args()

    transport_type = "train"
    if args.bus:
        transport_type = "bus"

    row_data = []
    with open(args.file, 'r') as f:
        for line in f.readlines():
            row_data.append(json.loads(line))

    points, associates = data.build_data_objects(row_data, transport_type, args.graph_version)
    points_table, associates_table = db.get_tables(args.endpoint, args.database, args.token)

    points_table.fill(list(points))
    associates_table.fill(list(associates))
