from __future__ import absolute_import, division, print_function, unicode_literals

import os

import ydb


class BaseTable:
    TABLE_NAME = None
    PATH = None

    def __init__(self, endpoint, database, token):
        self.connection_params = ydb.DriverConfig(
            endpoint=endpoint, database=database, auth_token=token
        )
        self._driver = None
        self._table_path = os.path.join(self.connection_params.database, self.PATH)
        self._full_table_name = os.path.join(self._table_path, self.TABLE_NAME)

    def _is_table_exists(self):
        try:
            return self._get_driver().scheme_client.describe_path(self._full_table_name).is_table()
        except ydb.SchemeError:
            return False

    def _is_directory_exists(self):
        try:
            return self._get_driver().scheme_client.describe_path(self._table_path).is_directory()
        except ydb.SchemeError:
            return False

    def _execute(self, query, params=None):
        if params is None:
            params = {}
        prepared_query = self._get_session().prepare(query)
        return self._get_session().transaction().execute(
            prepared_query, params, commit_tx=True
        )

    def _get_session(self):
        return self._get_driver().table_client.session().create()

    def _get_driver(self):
        if not self._driver:
            self._driver = ydb.Driver(self.connection_params)
            self._driver.wait(timeout=10)
        return self._driver

    def get_table_description(self):
        raise NotImplemented()

    def prepare(self):
        if not self._is_directory_exists():
            self._get_driver().scheme_client.make_directory(self._table_path)

        if not self._is_table_exists():
            self._get_session().create_table(
                self._full_table_name,
                self.get_table_description())
