import os

import jinja2

from travel.rasp.deploy_notifier.notifier import Event
from travel.rasp.deploy_notifier.notifier.utils import LoggingBase, extract_version


class BaseHandler(LoggingBase):
    def __init__(self):
        loader = jinja2.PackageLoader('travel.rasp.deploy_notifier.notifier.handler', 'templates')
        self._jinja_env = jinja2.Environment(loader=loader)
        self._jinja_env.globals.update(extract_version=extract_version)

    async def handle_base(self, event: Event) -> None:
        self._logger.info(event)

    async def __call__(self, event: Event) -> None:
        try:
            await getattr(self, f'handle_{event.source}', self.handle_base)(event)
        except Exception:
            self._logger.exception('Error while handling event.')
