from typing import Iterable

from aiotg import Bot

from travel.rasp.deploy_notifier.notifier import Event
from travel.rasp.deploy_notifier.notifier.handler import BaseHandler
from travel.rasp.deploy_notifier.notifier.utils import LoggingBase
from travel.rasp.deploy_notifier.notifier.utils.decorators import ensure_needs_handling
from travel.rasp.deploy_notifier.notifier.utils.make_yandex_paste import make_yandex_paste


class TelegramHandler(BaseHandler, LoggingBase):
    HTTP_TEMPLATES = {
        'qloud': 'web_qloud_telegram.j2',
    }

    def __init__(self, token: str, chat_id: str, post_statuses: Iterable[str]) -> None:
        super().__init__()
        self._bot = Bot(api_token=token)
        self._chat = self._bot.private(chat_id)
        self._post_statuses = set(post_statuses)

    async def handle_qloud(self, event: Event) -> None:
        pass

    @ensure_needs_handling('telegram')
    async def handle_http(self, event: Event) -> None:
        self._logger.info(f"TelegramHandler.handle_http event: {event}")
        if event.data.get('status') not in self._post_statuses:
            return
        if event.data.get('comment', '').strip():
            try:
                event.data['yandex_paste'] = await make_yandex_paste(event.data['comment'])
            except:
                self._logger.exception('Error while generating yandex paste url')
        content = self._jinja_env.get_template(self.HTTP_TEMPLATES[event.data['_source']]).render(**event.data),
        await self._chat.send_text(content, parse_mode='Markdown')

    async def start(self):
        await self._bot.run()
