import asyncio
from aiohttp import web

from travel.rasp.deploy_notifier.notifier.producer import BaseProducer
from travel.rasp.deploy_notifier.notifier.utils import LoggingBase
from travel.rasp.deploy_notifier.notifier.utils.api_clients import QloudAPI


class HTTPProducer(BaseProducer, LoggingBase):
    TITLE = 'http'

    def __init__(self, queue: asyncio.Queue) -> None:
        super().__init__()
        self._queue = queue

    async def __call__(self, request: web.Request) -> web.Response:
        try:
            event_data = await request.json()
            source = request.match_info['name']
            event_data['_source'] = source
            if source == 'qloud':
                event_data['url'] = QloudAPI.get_environment_url(event_data.get('environmentId', ''))
            event_data['_handlers'] = request.rel_url.query.get('handlers', '').split(',')

            event = self._make_event(event_data)
            self._logger.info(f'HTTPProducer new event: {event}')
            await self._queue.put(event)
            return web.json_response({'status': 'ok'})
        except Exception as e:
            self._logger.exception(e)
            return web.json_response({'status': 'error'})
