from typing import AsyncGenerator, Tuple

from travel.rasp.deploy_notifier.notifier.utils.api_clients.base import APIBase


class QloudAPI(APIBase):
    ENVIRONMENT_BASE_URL = 'https://platform.yandex-team.ru/projects/'

    def __init__(self, token: str, base_url: str='https://platform.yandex-team.ru/api/v1/') -> None:
        super().__init__(token, base_url, retries_count=10)

    async def get_project_environments_info(self, project: str) -> AsyncGenerator[dict, None]:
        data = await self._make_query('project/' + project)
        for application in data.get('applications', []):
            for environment in application.get('environments', []):
                yield environment

    async def get_project_environments_statuses(self, project: str) -> AsyncGenerator[Tuple[str, str], None]:
        async for environment in self.get_project_environments_info(project):
            yield environment.get('objectId'), environment.get('status')

    async def get_environment_info(self, environment_id: str) -> dict:
        return await self._make_query('environment/stable/' + environment_id)

    @classmethod
    def get_environment_url(cls, environment_id: str) -> str:
        return cls.ENVIRONMENT_BASE_URL + environment_id.replace('.', '/')
