from typing import Any, Dict, Sequence, Text

from travel.rasp.deploy_notifier.notifier.utils.api_clients.base import APIBase


class SandboxAPI(APIBase):
    def __init__(self, token: str, base_url: str='http://sandbox.yandex-team.ru/api/v1.0/') -> None:
        super().__init__(token, base_url, retries_count=5)

    async def create_task(self, task_type: str, owner: str, description: Text,
                          custom_fields: Sequence[Dict[str, Any]]) -> dict:
        return await self._make_query('task', method='post', json={
            "children": {},
            "type": task_type,
            "owner": owner,
            "status": "DRAFT",
            "description": description,
            "custom_fields": custom_fields,
        })

    async def start_tasks(self, task_ids: Sequence[int]):
        return await self._make_query('batch/tasks/start', method='put', json=task_ids)
