import logging
from functools import wraps

from travel.rasp.deploy_notifier.notifier import Event


def ensure_needs_handling(handler_name: str):
    def _ensure_needs_handling_decorator(f):
        @wraps(f)
        async def _ensure_needs_handling(self, event: Event):
            source = event.data.get('_source')
            if source not in self.HTTP_TEMPLATES:
                getattr(self, '_logger', logging.getLogger(__name__)).error(f'Bad event source: {source}.')
                return

            if handler_name in event.data.get('_handlers', []):
                await f(self, event)
        return _ensure_needs_handling
    return _ensure_needs_handling_decorator
