from typing import Callable, Iterable

from aiohttp import web

from travel.rasp.deploy_notifier.notifier.utils import LoggingBase


class HTTPListener(LoggingBase):
    def __init__(self, host: str='localhost', port: int=8080, routes: Iterable[Callable]=()) -> None:
        super().__init__()
        self._host = host
        self._port = port
        self._routes = tuple(routes)

    async def start(self) -> None:
        self._logger.info(f'Starting http listener on {self._host}:{self._port}...')

        app = web.Application()
        app.add_routes(self._routes)

        runner = web.AppRunner(app)
        await runner.setup()
        site = web.TCPSite(runner, self._host, self._port)
        await site.start()
