from typing import Text

import aiohttp


PASTE_URL = 'https://paste.yandex-team.ru/'


async def make_yandex_paste(text: Text, file_type: str='plain') -> str:
    data = {
        'syntax': file_type,
        'text': text
    }
    async with aiohttp.ClientSession() as session:
        response = await session.post(PASTE_URL, data=data)
        response.raise_for_status()
        return str(response.url)
