PY3_LIBRARY(deploy-notifier)

OWNER(
    g:rasp-back
)

PEERDIR(
    contrib/python/aiohttp
    contrib/python/aiotg
    contrib/python/Jinja2
    contrib/python/pathlib2

    library/python/resource
    library/python/startrek_python_client
    library/python/ylog

    travel/library/python/rasp_vault
)


PY_SRCS(
    main.py

    notifier/__init__.py
    notifier/event.py
    notifier/notifier.py

    notifier/handler/__init__.py
    notifier/handler/base.py
    notifier/handler/load_testing_handler.py
    notifier/handler/startrek_handler.py
    notifier/handler/telegram_handler.py

    notifier/producer/__init__.py
    notifier/producer/base.py
    notifier/producer/http_producer.py
    notifier/producer/qloud_producer.py

    notifier/utils/__init__.py
    notifier/utils/decorators.py
    notifier/utils/extract_version.py
    notifier/utils/http_listener.py
    notifier/utils/logging_base.py
    notifier/utils/make_yandex_paste.py

    notifier/utils/api_clients/__init__.py
    notifier/utils/api_clients/base.py
    notifier/utils/api_clients/qloud.py
    notifier/utils/api_clients/sandbox.py
)

RESOURCE_FILES(
    PREFIX travel/rasp/deploy_notifier/
    notifier/handler/templates/qloud_startrek.j2
    notifier/handler/templates/web_qloud_startrek.j2
    notifier/handler/templates/web_qloud_telegram.j2
    notifier/handler/templates/web_sandbox_startrek.j2
)

END()

RECURSE(
    bin
)
