
debug_enable() {
    virtualenv /app/.env
    /app/.env/bin/pip install py-spy

    supervisorctl stop app
    rm /app/app
    ln -s /app/app_debug /app/app
    supervisorctl start app

    echo ""
    echo ""
    echo ""
    echo ""
    echo ""
    echo ""
    echo ""
    echo ""
    echo "Now wait for gunicorn workers to spawn (ps aux|grep app)"
    echo "    ps aux|grep app"
    echo "Then use:"
    echo "    sudo /app/.env/bin/py-spy record -p <PID> -o pf.svg"
    echo "Open pf.svg in your browser to see the flamegraph"
}

debug_disable() {
    supervisorctl stop app
    rm /app/app
    ln -s /app/app_no_debug /app/app
    supervisorctl start app
}

case "$1" in
    enable)
        debug_enable
    ;;
    disable)
        debug_disable
    ;;
    *)
        echo "Usage:"
        echo "    debug.sh enable"
        echo "    debug.sh disable"
    ;;
esac
