# coding: utf8

from mongoengine import Q
from xml.etree import ElementTree

from common.views.teasers import TeaserSetRaspBase


class TeaserSetExport(TeaserSetRaspBase):
    def __init__(self, page_code, data=None, national_version=None, lang=None):
        super(TeaserSetExport, self).__init__('export', page_code, data=data,
                                              national_version=national_version, language=lang)

    def additional_filter(self):
        return Q(text_short__exists=True) & Q(text_short__ne='')


def teasers_to_xml(teaser_set):
    teasers_el = ElementTree.Element('teasers')
    if teaser_set:
        teasers_by_type = teaser_set.get_teasers_by_type_with_selected()

        for type_, teasers in teasers_by_type.items():
            for teaser in teasers:
                teaser_el = ElementTree.SubElement(teasers_el, 'teaser')
                teaser_el.set('title', teaser.title or u'')
                teaser_el.set('url', teaser.url or u'')
                teaser_el.set('image_url', (teaser.image.name and teaser.image.url) or u'')
                teaser_el.set('selected', u'1' if getattr(teaser, 'selected', None) else u'0')
                teaser_el.set('id', str(teaser.id))

                ElementTree.SubElement(teaser_el, 'content').text = teaser.content
                ElementTree.SubElement(teaser_el, 'mobile_content').text = teaser.mobile_content

    return teasers_el
