# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.utils.errorhandlers import url, handler_test_patterns
from common.views.db_info import db_info
from django.conf.urls import include
from travel.rasp.export.export.views.airports import airports
from travel.rasp.export.export.views.city import city_stations, city_directions
from travel.rasp.export.export.views.country import country_directions
from travel.rasp.export.export.views.dev.companies_crashes import CompaniesCrashesView
from travel.rasp.export.export.views.dev.current_events import CurrentEventsView
from travel.rasp.export.export.views.in_xml import (
    trip, search, station_schedule, thread, trip_v2, search_v2, station_schedule_v2, thread_v2)
from travel.rasp.export.export.views.schedule_changes import schedule_changes
from travel.rasp.export.export.views.station import station_info
from travel.rasp.export.export.views.suburban import zones, zone, zone_v2, zones_v2
from travel.rasp.export.export.views.thread import linked_threads
from travel.rasp.export.export.views.version import version

urlpatterns = [
    url(r'^v3/', include('travel.rasp.export.export.v3.urls')),

    url(r'^version/?$', version),

    url(r'^export/suburban/country/(?P<country_id>\d+)/directions/?', country_directions),

    url(r'^export/suburban/city/(?P<city_id>\d+)/stations/?', city_stations),
    url(r'^export/suburban/city/(?P<city_id>\d+)/directions/?', city_directions),

    # Старый интерфейс поиска xml
    url(r'^export/suburban/trip/(?P<esr_from>\d+)/(?P<esr_to>\d+)/?', trip),
    # Новый интерфейс RASP-4936
    url(r'^export/suburban/search/?', search),

    url(r'^export/suburban/station/(?P<esr_code>\d+)/info/?', station_info),
    url(r'^export/suburban/station/(?P<esr_code>\d+)/?', station_schedule),
    url(r'^export/suburban/thread/(?P<uid>[^/]+)/?', thread),

    url(r'^export/suburban/zones/?$', zones),
    url(r'^export/suburban/zones/(?P<zone_id>\d+)/?', zone),

    # /v2/
    url(r'^export/v2/suburban/trip/(?P<esr_from>\d+)/(?P<esr_to>\d+)/?', trip_v2),
    url(r'^export/v2/suburban/search/?', search_v2),
    url(r'^export/v2/suburban/station/(?P<esr_code>\d+)/info/?', station_info),

    url(r'^export/v2/suburban/station/(?P<esr_code>\d+)/?', station_schedule_v2),
    url(r'^export/v2/suburban/thread/(?P<uid>[^/]+)/linked/?', linked_threads),
    url(r'^export/v2/suburban/thread/(?P<uid>[^/]+)/?', thread_v2),

    url(r'^export/v2/suburban/zones/?$', zones_v2),
    url(r'^export/v2/suburban/zones/(?P<zone_id>\d+)/?', zone_v2),

    url(r'^export/v2/suburban/schedule_changes/?', schedule_changes),
    # ~/v2/

    url(r'^export/airports/?$', airports),

    url(r'^dev/current_events/?$', CurrentEventsView.as_view()),
    url(r'^dev/companies_crashes/?$', CompaniesCrashesView.as_view()),
    url(r'^dev/dbinfo$', db_info),
] + handler_test_patterns
