# coding: utf8

import inspect
from rest_framework import status

from common.utils.exceptions import SimpleUnicodeException


class UserUseError(SimpleUnicodeException):
    """
    Ошибка использования приложения клиентом.
    """

    def __init__(self, message, status_code=status.HTTP_400_BAD_REQUEST):
        self.message = message
        self.status_code = status_code

        stack = inspect.stack()
        caller_frame_record = stack[1]
        line_no = caller_frame_record[2]
        self.error_code = line_no

        msg = u'Error: {} {} {}'.format(
            self.error_code, self.status_code, self.message
        )

        super(UserUseError, self).__init__(msg)
