# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.dynamic_settings.default import conf


def get_settings():
    return {
        'auto_update_interval': conf.SUBURBAN_APP_AUTO_UPDATE_INTERVAL,
        'info_banner': conf.SUBURBAN_INFO_BANNER,
        'ugc_notification_scheduled_time_send_seconds': conf.UGC_NOTIFICATION_SCHEDULED_TIME_SEND_SECONDS,
        'ugc_notification_timeout_seconds': conf.UGC_NOTIFICATION_TIMEOUT_SECONDS,
        'ugc_station_near_distance_metres': conf.UGC_STATION_NEAR_DISTANCE_METRES,
        'promo_search': conf.SUBURBAN_PROMO_SEARCH,
        'promo_favorites': conf.SUBURBAN_PROMO_FAVORITES,
        'promo_station': conf.SUBURBAN_PROMO_STATION,
        'drive_integration': conf.SUBURBAN_DRIVE_INTEGRATION,
        'music_integration': conf.SUBURBAN_MUSIC_INTEGRATION,
        'aeroex_selling': conf.SUBURBAN_AEROEX_SELLING_ENABLED and conf.SUBURBAN_SELLING_ENABLED,
        'movista_selling': conf.SUBURBAN_MOVISTA_SELLING_ENABLED and conf.SUBURBAN_SELLING_ENABLED,
        'movista_selling_ios': conf.SUBURBAN_MOVISTA_SELLING_ENABLED_IOS and conf.SUBURBAN_SELLING_ENABLED,
        'im_selling': conf.SUBURBAN_IM_SELLING_ENABLED and conf.SUBURBAN_SELLING_ENABLED,
        'im_selling_ios': conf.SUBURBAN_IM_SELLING_ENABLED_IOS and conf.SUBURBAN_SELLING_ENABLED,
        'enable_apple_pay': False,  # Deprecated
        'apple_pay_enabled': conf.SUBURBAN_SELLING_ENABLE_APPLE_PAY,
        'enable_google_pay': conf.SUBURBAN_SELLING_ENABLE_GOOGLE_PAY,
        'enable_payment_sdk_ios': False,  # Deprecated
        'payment_sdk_ios_enabled': conf.SUBURBAN_SELLING_ENABLE_PAYMENT_SDK_IOS,
        'enable_payment_sdk_android': conf.SUBURBAN_SELLING_ENABLE_PAYMENT_SDK_ANDROID,
        'polling_max_orders_count_in_request': conf.SUBURBAN_POLLING_MAX_ORDERS_COUNT_IN_REQUEST,
        'polling_orders_first_time_step': conf.SUBURBAN_POLLING_ORDERS_FIRST_TIME_STEP,
        'polling_orders_exp_backoff': conf.SUBURBAN_POLLING_ORDERS_EXP_BACKOFF,
        'polling_orders_max_calls_count': conf.SUBURBAN_POLLING_ORDERS_MAX_CALLS_COUNT,
        'polling_orders_max_minutes_offset': conf.SUBURBAN_POLLING_ORDERS_MAX_MINUTES_OFFSET,
        'polling_orders_show_spinner_time': conf.SUBURBAN_POLLING_ORDERS_SHOW_SPINNER_TIME,
        'camera_x_enabled': conf.SUBURBAN_CAMERA_X_ENABLED,
        'updater_enabled': conf.SUBURBAN_UPDATER_ENABLED,
        'updater_url': conf.SUBURBAN_UPDATER_URL,
        'lib_ssl_enabled': conf.SUBURBAN_LIB_SSL_ENABLED,
        'yandex_ca_challenge_handler_enabled_ios': conf.SUBURBAN_YANDEX_CA_CHALLENGE_HANDLER_ENABLED_IOS
    }
