# coding: utf8

import logging

from common.models.geo import StationType

from travel.rasp.export.export.v3.core.helpers import set_key

log = logging.getLogger(__name__)


def get_station_info(station):
    station_data = {
        'address': station.L_address(),
        'latitude': station.latitude,
        'longitude': station.longitude,
    }

    phones = [phone.phone for phone in station.stationphone_set.all()]
    set_key(station_data, 'phones', phones)

    return station_data


def get_station_types():
    stations_types = []

    for station_type in StationType.objects.all():
        stations_types.append({
            'id': station_type.id,
            'name': station_type.L_name(),
            'name_gen': station_type.L_name(case='genitive', fallback=False) or None,
            'name_acc': station_type.L_name(case='accusative', fallback=False) or None,
            'name_dat': station_type.L_name(case='dative', fallback=False) or None
        })

    return stations_types
