# coding: utf8

from mongoengine import Q

from common.views.teasers import TeaserSetRaspBase


class TeaserSetExport(TeaserSetRaspBase):
    def __init__(self, page_code, data=None, national_version=None, lang=None):
        super(TeaserSetExport, self).__init__(project='export', page_code=page_code, data=data,
                                              national_version=national_version, language=lang)

    def additional_filter(self):
        return Q(text_short__exists=True) & Q(text_short__ne='')


def prepare_teasers(teaser_set):
    teasers_list = []
    if teaser_set:
        teasers_by_type = teaser_set.get_teasers_by_type_with_selected()

        for type_, teasers in teasers_by_type.items():
            for teaser in teasers:
                teaser_dict = {
                    'title': teaser.title or None,
                    'url': teaser.url or None,
                    'image_url': (teaser.image.name and teaser.image.url) or None,
                    'selected': getattr(teaser, 'selected', False),
                    'id': teaser.uid64,
                    'content': teaser.content or None,
                    'mobile_content': teaser.mobile_content or None
                }
                teasers_list.append(teaser_dict)

    return teasers_list


def get_search_teasers(segments, point_from, point_to, lang=None, national_version=None):
    teaser_set = TeaserSetExport(
        'search_suburban',
        data={
            'points': [point_from, point_to],
            'routes': segments
        },
        national_version=national_version,
        lang=lang
    )
    return prepare_teasers(teaser_set)


def get_thread_teasers(thread, lang=None, national_version=None):
    teaser_set = TeaserSetExport(
        'thread_{}'.format(thread.t_type.code),
        data=(thread, thread.company),
        national_version=national_version,
        lang=lang
    )
    return prepare_teasers(teaser_set)


def get_station_schedule_teasers(station, schedule_routes, lang=None, national_version=None):
    teaser_set = TeaserSetExport(
        'tablo',
        data=(station, schedule_routes),
        national_version=national_version,
        lang=lang
    )
    return prepare_teasers(teaser_set)
