# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import json

from common.db.mds.clients import mds_s3_common_client

from travel.rasp.export.export.v3.views.base_view import BaseView


class NearestSuburbanStationsView(BaseView):
    """
    https://st.yandex-team.ru/RASPEXPORT-273
    В tasks генерируются данные о ближайших и главных в городе станциях электричках для ПП.
    Данные складываются в mds.
    При запросе в export от ПП данные достаются из mds.
    """
    def handle(self, request, *args, **kwargs):
        return json.load(mds_s3_common_client.get_data(key='suburban/export_nearest_suburban_stations.json'))


class NearestMainStationsView(BaseView):
    """
    https://st.yandex-team.ru/RASPFRONT-6481
    """
    def handle(self, request, *args, **kwargs):
        return json.load(mds_s3_common_client.get_data(key='suburban/export_nearest_suburban_main_stations.json'))
