# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings
from pybreaker import CircuitBreaker

from common.settings.configuration import Configuration
from common.settings.utils import define_setting


define_setting(
    'SUBURBAN_SELLING_URL',
    {Configuration.PRODUCTION: 'https://suburban-selling.rasp.yandex.net'},
    default='https://testing.suburban-selling.rasp.yandex.net'
)
define_setting('SUBURBAN_SELLING_API_TIMEOUT', {Configuration.PRODUCTION: 2}, default=5)
define_setting('SUBURBAN_SELLING_BREAKER_PARAMS', default={'fail_max': 3, 'reset_timeout': 60})


suburban_selling_breaker = CircuitBreaker(**settings.SUBURBAN_SELLING_BREAKER_PARAMS)
