# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf.urls import url

from travel.rasp.export.export.v3.partners.nearest_suburbans import (
    NearestSuburbansView, NearestSuburbansAllView, NearestSuburbansMainStationsView
)
from travel.rasp.export.export.v3.partners.nearest_suburban_stations import (
    NearestSuburbanStationsView, NearestMainStationsView
)
from travel.rasp.export.export.v3.views.search import SearchView, SearchOnDateView
from travel.rasp.export.export.v3.views.search_dynamic_data import SearchDynamicDataView
from travel.rasp.export.export.v3.views.search_train_tariffs import SearchTrainTariffsView
from travel.rasp.export.export.v3.views.settings import SettingsView
from travel.rasp.export.export.v3.views.station import StationView, StationTypesProxyView
from travel.rasp.export.export.v3.views.station_schedule import StationScheduleView, StationScheduleOnDateView
from travel.rasp.export.export.v3.views.thread import ThreadView, ThreadOnDateView
from travel.rasp.export.export.v3.views.zones import ZoneProxyView, ZonesProxyView


urlpatterns = [
    url(r'^suburban/search_on_date/?$', SearchOnDateView.as_view()),
    url(r'^suburban/search/?$', SearchView.as_view()),
    url(r'^suburban/search_dynamic_data/?$', SearchDynamicDataView.as_view()),

    url(r'^suburban/thread_on_date/(?P<uid>[^/]+)/?$', ThreadOnDateView.as_view()),
    url(r'^suburban/thread/(?P<uid>[^/]+)/?$', ThreadView.as_view()),

    url(r'^suburban/station_schedule_on_date/(?P<esr_code>\d+)/?$', StationScheduleOnDateView.as_view()),
    url(r'^suburban/station_schedule/(?P<esr_code>\d+)/?$', StationScheduleView.as_view()),
    url(r'^suburban/station/(?P<esr_code>\d+)/?$', StationView.as_view()),
    url(r'^suburban/station/(?P<esr_code>\d+)/info/?$', StationView.as_view()),
    url(r'^suburban/station/types/?$', StationTypesProxyView.as_view()),

    url(r'^suburban/zones/?$', ZonesProxyView.as_view()),
    url(r'^suburban/zone/(?P<zone_id>\d+)/?$', ZoneProxyView.as_view()),

    url(r'^suburban/settings/?$', SettingsView.as_view()),

    url(r'^suburban/search_train_tariffs/?$', SearchTrainTariffsView.as_view()),

    url(r'^partners/nearest_suburban_stations/?$', NearestSuburbanStationsView.as_view()),
    url(r'^partners/nearest_suburban_main_stations/?$', NearestMainStationsView.as_view()),
    url(r'^partners/nearest_suburban_to_from_center/?$', NearestSuburbansView.as_view()),
    url(r'^partners/nearest_suburban_to_from_center_all/?$', NearestSuburbansAllView.as_view()),
    url(r'^partners/nearest_suburban_main_stations_departures/?$', NearestSuburbansMainStationsView.as_view()),
]
