# coding: utf8

import logging

from travel.rasp.export.export.v3.core.thread import get_thread_on_date, get_thread_on_all_days
from travel.rasp.export.export.v3.views.base_view import BaseView
from travel.rasp.export.export.v3.views.request_schemas import ThreadRequestSchema, ThreadOnDateRequestSchema
from travel.rasp.export.export.v3.views.utils import try_get_thread


log = logging.getLogger(__name__)


class ThreadView(BaseView):
    def handle(self, request, uid, *args, **kwargs):
        query, errors = ThreadRequestSchema(context={'request': request}).load(request.GET)
        national_version, lang = request.national_version, request.language_code
        thread = try_get_thread(uid=uid)
        return get_thread_on_all_days(thread, national_version=national_version, lang=lang,
                                      station_from_id=query['station_from_id'], station_to_id=query['station_to_id'])


class ThreadOnDateView(BaseView):
    def handle(self, request, uid, *args, **kwargs):
        query, errors = ThreadOnDateRequestSchema(context={'request': request}).load(request.GET)
        national_version, lang = request.national_version, request.language_code
        thread = try_get_thread(uid=uid)
        return get_thread_on_date(thread, query['dt'], national_version=national_version, lang=lang,
                                  station_from_id=query['station_from_id'], station_to_id=query['station_to_id'],
                                  disable_cancels=query['disable_cancels'])
