# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from collections import defaultdict

from common.apps.suburban_events.models import CompanyCrash
from common.models.schedule import Company

from travel.rasp.export.export.v3.views.base_view import BaseView


class CompaniesCrashesView(BaseView):
    """
    Информация об авариях компаний-перевозчиков при получении данных от РЖД.
    Авария - количество событий для перевозчика в очередном пакете данных РЖД
    существенно меньше среднего значения.
    https://st.yandex-team.ru/RASPEXPORT-323
    """

    def handle(self, request, *args, **kwargs):
        companies_info = defaultdict(dict)
        for crash in CompanyCrash.objects.all():
            companies_info[crash.company] = {
                'first_dt': crash.first_dt.isoformat(),
                'last_dt': crash.last_dt.isoformat() if crash.last_dt else None,
                'first_rate': crash.first_rate,
                'last_rate': crash.last_rate,
                'company_average_rate': crash.avr_rate,
            }

        for company in Company.objects.filter(id__in=companies_info.keys()):
            companies_info[company.id].update({
                'title': company.L_title()
            })

        return companies_info
