import logging

from lxml import etree

from common.utils.httpresponses import xmlresponse
from travel.rasp.export.export.views.in_xml import get_station_by_esr_or_404

logger = logging.getLogger(__name__)


@xmlresponse
def station_info(request, esr_code):
    station = get_station_by_esr_or_404(esr_code)
    station_el = etree.Element(
        'station',
        attrib={
            'address': station.L_address(),
            'latitude': str(station.latitude),
            'longitude': str(station.longitude),
        }
    )

    phones_el = etree.SubElement(station_el, 'phones')
    for phone in station.stationphone_set.all():
        phone_el = etree.SubElement(phones_el, 'phone')
        phone_el.text = phone.phone

    return station_el
