# -*- coding: utf-8 -*-

from django.http import HttpResponse
from django.shortcuts import get_object_or_404
from xml.etree import ElementTree

from common.models.schedule import RThread, RThreadType
from common.models_utils import fetch_related
from travel.rasp.library.python.common23.date import environment
from common.utils.date import MSK_TZ
from common.utils.httpresponses import xmlresponse

from travel.rasp.export.export.views.in_xml import fill_days_and_except_texts


@xmlresponse
def linked_threads(request, uid):
    today = environment.today()

    base_thread = get_object_or_404(RThread, uid=uid)
    if base_thread.type_id != RThreadType.BASIC_ID:
        base_type_code = RThreadType.objects.get(id=RThreadType.BASIC_ID).code
        return HttpResponse(u'<error text="Переданный uid соответствует нитке с типом {}.'
                            u' Требуется нитка с типом {}."/>'.format(base_thread.type.code, base_type_code),
                            content_type='application/xml')

    linked_threads_objs = RThread.objects.filter(basic_thread_id=base_thread.id)
    fetch_related(linked_threads_objs, 'type')
    threads_el = ElementTree.Element('threads')

    def add_thread_el(thread):
        thread_el = ElementTree.SubElement(threads_el,
                                           'thread',
                                           title=thread.L_title(),
                                           type=thread.type.code,
                                           uid=thread.uid)

        first_rtstation = list(thread.path.select_related('station'))[0]
        thread_start_date = thread.get_thread_tz_start_date(today, MSK_TZ)
        shift = first_rtstation.calc_days_shift(event='departure', start_date=thread_start_date)
        fill_days_and_except_texts(thread_start_date, thread_el, thread, shift, add_days_mask=True)

    add_thread_el(base_thread)
    for thread in linked_threads_objs:
        add_thread_el(thread)

    return threads_el
