# -*- coding: utf-8 -*-

from datetime import datetime, time, timedelta

import pytz
from xml.etree import ElementTree

from travel.rasp.library.python.common23.date.environment import now_aware
from common.xgettext.i18n import gettext as _


def add_subelement(root, name, text=None, attrib=None):
    """ Добавляет к элементу дочерний """

    element = ElementTree.SubElement(root, name)

    if text:
        element.text = unicode(text)

    if attrib:
        element.attrib.update(attrib)

    return element


def append_station_title_prefix(station, title):
    if station.t_type_id == 2:
        return _(u'аэропорт %s') % title
    else:
        return title


def add_server_time(response_element):
    server_time_el = ElementTree.Element('server_time')
    server_time_el.text = now_aware().astimezone(pytz.utc).isoformat(' ')
    response_element.append(server_time_el)


def get_day_start_end_utc_in_iso(day, tz):
    start_day = tz.localize(datetime.combine(day, time())).astimezone(pytz.utc).isoformat(' ')
    end_day = tz.localize(datetime.combine(day, time(23, 59, 59))).astimezone(pytz.utc).isoformat(' ')
    return start_day, end_day


def get_today_tomorrow_date(date_str, from_tz):
    if date_str in ['today', 'tomorrow']:
        msk_dt = now_aware()
        if date_str == 'tomorrow':
            msk_dt += timedelta(1)
        return msk_dt.astimezone(from_tz).date()


def get_sub_version(request):
    sub_version_str = request.GET.get('sub_version', '2')
    return float(sub_version_str)
