# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import os

from common.settings import *  # noqa
from common.settings import COMMON_CONTRIB_APPS, COMMON_INSTALLED_APPS, XGETTEXT_KEYSETS
from common.settings.configuration import BaseConfigurator, Configuration
from common.settings.utils import configure_raven, get_app_version
from travel.rasp.library.python.common23.logging.configure import configure_default_logging

DEBUG = False
ENABLE_SUBURBAN_STATES = True

USE_I18N = True

# If you set this to False, Django will not use timezone-aware datetimes.
USE_TZ = False

# Make this unique, and don't share it with anybody.
SECRET_KEY = 'jglkgl8976&&h09$$0c$nbre^8^55hb=7l1q57+h63dme^g*&amp;j8=)n'

LOG_PATH = '/var/log/app'
PACKAGE = 'yandex-rasp-api-public'
PKG_VERSION = get_app_version()


MIDDLEWARE_CLASSES = (
    'django_opentracing.OpenTracingMiddleware',
    'travel.library.python.tracing.django.TracingMiddleware',
    'common.middleware.extract_context.ExtractRequestMiddleware',
    'common.middleware.ping.PingResponder',
    'django.middleware.common.CommonMiddleware',
    'common.middleware.now.Now',
    'common.middleware.request_activator.RequestActivator',
    'travel.rasp.export.export.middleware.LanguageAndNationalVersion',
)

ROOT_URLCONF = 'travel.rasp.export.export.urls'

# Python dotted path to the WSGI application used by Django's runserver.
WSGI_APPLICATION = 'travel.rasp.export.wsgi.application'

OPENTRACING_TRACE_ALL = True
OPENTRACING_TRACED_ATTRIBUTES = ['path', 'method']

ALLOWED_HOSTS = ['*']

INSTALLED_APPS = COMMON_CONTRIB_APPS + COMMON_INSTALLED_APPS + [
    'django_opentracing',
    'stationschedule',
    'route_search',
    'raven.contrib.django.raven_compat',
    'travel.rasp.export.export',
]

# Основные директории проекта
PROJECT_PATH = os.path.abspath(os.path.join(os.path.dirname(__file__), ''))
EXPORT_PATH = os.path.join(PROJECT_PATH, 'export/www/db/scripts/export')
EXPORT_SUBURBAN_PATH = os.path.join(EXPORT_PATH, 'suburban')

try:
    SUBMODULE_STATUS = open(
        os.path.join(os.path.dirname(__file__), '', 'submodule-status')
    ).read()
except IOError:
    SUBMODULE_STATUS = None


def with_suffix(suffix, prefixes):
    return [prefix + suffix for prefix in prefixes]


PRECACHE_MANAGERS = [
    'common.models.geo:StationType.objects',
    'common.models.geo:StationMajority.objects',
    'common.models.transport:TransportType.objects',
    'common.models.transport:TransportModel.objects',
    'common.models.transport:TransportSubtypeColor.objects',
    'common.models.geo:Country.objects',
    'common.models.geo:Region.objects',
    'common.models.geo:Settlement.objects',
    'common.models.schedule:RThreadType.objects',
    'common.models.schedule:Supplier.objects',
    'common.models.geo:Direction.objects',
    'common.models.geo:ExternalDirection.objects',
    'common.models.tariffs:SuburbanTariff.objects',
    'common.models.tariffs:TariffType.objects',
    'common.models.schedule:Company.objects',
    'common.models.schedule:PlatformTranslation.objects',
    'common.models.geo:DirectionTranslate.objects',
    'common.models.geo:DirectionFromTranslate.objects',
    'common.models.geo:Station.code_manager',
]

XGETTEXT_KEYSETS.update({
    'export': {
        'filename': 'export/xgettext/keyset.json',
        'dirs': [
            'export',
        ]
    },
    'stationschedule': {
        'filename': 'stationschedule/xgettext/keyset.json',
        'dirs': [
            'stationschedule',
        ]
    }
})

USERS_SEARCH_LOG = None

REST_FRAMEWORK = {
    'DEFAULT_RENDERER_CLASSES': (
        'rest_framework.renderers.JSONRenderer',
    )
}


def context_extractor(request):
    return {
        'user_rid': request.GET.get('_rid', ''),
        'service_rid': request.META.get('HTTP_X_REQUEST_ID', '')
    }


PYLOGCTX_REQUEST_EXTRACTOR = context_extractor


class ExportConfigurator(BaseConfigurator):
    def apply_base(self, settings):
        base_log_level = os.environ.get('RASP_BASE_LOG_LEVEL', 'INFO')
        format_with_context = '%(levelname)s %(asctime)s %(context)s %(process)d %(name)s %(message)s'
        settings['LOGGING'] = configure_default_logging(settings, base_log_level, format_with_context,
                                                        jaeger_tracing=True)

    def apply_production(self, settings):
        configure_raven(settings, 'export')

        settings['USERS_SEARCH_LOG'] = os.path.join(settings['LOG_PATH'], 'yt/search.log')

    def apply_testing(self, settings):
        configure_raven(settings, 'export')

    def apply_stress(self, settings):
        settings['ENABLE_SUBURBAN_STATES'] = True


Configuration.configurator_classes += [ExportConfigurator]
