PY2_LIBRARY()

OWNER(
    g:rasp-back
)

PEERDIR(
    contrib/python/ipython

    travel/library/python/tracing/django
    travel/library/python/tracing/gunicorn
    travel/library/python/tracing/instrumentation

    travel/library/python/entrypoint

    travel/rasp/library/python/common
    travel/rasp/library/python/geosearch
    travel/rasp/library/python/route_search
    travel/rasp/library/python/stationschedule
    travel/rasp/library/python/tracing

    travel/library/python/dev/pydevd_inject
)

PY_SRCS(
    TOP_LEVEL
    settings.py
)

PY_SRCS(
    docker/local_settings.py

    app.py
    direction_stations.py
    gunicorn_conf.py
    wsgi.py

    export/__init__.py
    export/app.py
    export/middleware.py
    export/teasers.py
    export/urls.py

    export/v3/__init__.py

    export/v3/core/__init__.py
    export/v3/core/errors.py
    export/v3/core/helpers.py
    export/v3/core/search.py
    export/v3/core/settings.py
    export/v3/core/station.py
    export/v3/core/station_schedule.py
    export/v3/core/suburban_events.py
    export/v3/core/tariffs/__init__.py
    export/v3/core/tariffs/tariffs.py
    export/v3/core/tariffs/train_tariffs.py
    export/v3/core/teasers.py
    export/v3/core/thread.py
    export/v3/core/tracing.py
    export/v3/core/zones.py

    export/v3/partners/__init__.py
    export/v3/partners/nearest_suburban_stations.py
    export/v3/partners/nearest_suburbans.py
    export/v3/partners/suburban_states.py

    export/v3/selling/__init__.py
    export/v3/selling/suburban.py
    export/v3/selling/train_api.py

    export/v3/urls.py

    export/v3/views/__init__.py
    export/v3/views/base_view.py
    export/v3/views/request_schemas.py
    export/v3/views/search.py
    export/v3/views/search_dynamic_data.py
    export/v3/views/search_train_tariffs.py
    export/v3/views/settings.py
    export/v3/views/station.py
    export/v3/views/station_schedule.py
    export/v3/views/thread.py
    export/v3/views/utils.py
    export/v3/views/zones.py

    export/views/__init__.py
    export/views/airports.py
    export/views/city.py
    export/views/country.py
    export/views/dev/__init__.py
    export/views/dev/companies_crashes.py
    export/views/dev/current_events.py
    export/views/in_xml.py
    export/views/schedule_changes.py
    export/views/station.py
    export/views/suburban.py
    export/views/tariffs.py
    export/views/thread.py
    export/views/utils.py
    export/views/version.py
)

RESOURCE_FILES(
    export/xgettext/keyset.json
)

END()

RECURSE(
    bin
)

RECURSE_FOR_TESTS(
    tests
)
