package internal

import (
	"fmt"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
)

type LogConfig struct {
	Level string `config:"logging-level" yaml:"level"`
}

var DefaultLoggingConfig = LogConfig{
	Level: "info",
}

func New(config *LogConfig) (*zap.Logger, error) {
	level, err := log.ParseLevel(config.Level)
	if err != nil {
		return nil, fmt.Errorf("bad log level format: %w", err)
	}
	logger, err := zap.NewDeployLogger(level)
	if err != nil {
		return nil, fmt.Errorf("cannot create logger: %w", err)
	}
	return logger, nil
}
