package utils

import (
	"a.yandex-team.ru/travel/rasp/http_proxy_cache/proto"
	"github.com/golang/protobuf/ptypes"
	"io/ioutil"
	"net/http"
	"time"
)

func NewCacheRecord(response *http.Response) (*http_proxy_cache.TCacheRecord, error) {
	defer response.Body.Close()
	responseBody, err := ioutil.ReadAll(response.Body)
	if err != nil {
		return nil, err
	}
	createdAt, err := ptypes.TimestampProto(time.Now())
	if err != nil {
		return nil, err
	}
	record := &http_proxy_cache.TCacheRecord{
		ResponseStatusCode: int32(response.StatusCode),
		ResponseHeader:     toProtoHeader(response.Header),
		ResponseBody:       responseBody,
		CreatedAt:          createdAt,
	}
	return record, nil
}

func toProtoHeader(header http.Header) []*http_proxy_cache.THttpHeader {
	var result []*http_proxy_cache.THttpHeader
	for key, values := range header {
		ph := &http_proxy_cache.THttpHeader{
			Key: key,
			Values: values,
		}
		result = append(result, ph)
	}
	return result
}
