# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

"""
Пример настроек для локального запуска админки infocenter.
См. комменты.

Запускаю для тестинга примерно так:
RASP_VAULT_PATH=/Users/monitorius/work/data/yav \
QLOUD_DATACENTER=sas \
QLOUD_PROJECT=test \
YENV_TYPE=testing \
YENV_NAME=other \
RASP_GEOBASE_LAZY_LOAD=1 \
Y_PYTHON_SOURCE_ROOT="/Users/monitorius/work/arc/arcadia" ./app
"""

import os
import sys

from travel.rasp.info_center.settings import *  # noqa
from common.settings.configuration import Configuration


DEBUG = True
BASE_LOG_LEVEL = 'DEBUG'
DISABLE_GROUP_CACHES = True

# меняем путь логов, чтобы не пытаться писать по-умолчанию в /var/log
LOG_PATH = os.path.join(PROJECT_PATH, 'log')

# не смотрим на наш хостнейм
ALLOWED_HOSTS = ['*']

# влкючаем ручки админки
ENABLE_INTERNAL_HANDLES = True

# Рядом с бинарником должна лежать статика.
# Устанавливаем STATIC_ROOT рядом с бинарником, выполняем collectstatic:
# RASP_VAULT_IGNORE_ERRORS=1 RASP_IS_BUILDING=yes DJANGO_SETTINGS_MODULE=local_settings Y_PYTHON_ENTRY_POINT=travel.rasp.info_center.app:manage ./app collectstatic --no-input
exec_dir = os.path.dirname(sys.executable)
STATIC_ROOT = os.path.join(exec_dir, 'static')


# чтобы не париться с авторизацией, отключаем YaTeamUserAuth и логинимся автоматом (юзер должен быть в базе)
class MyAuth(object):
    def process_request(self, request):
        from django.contrib.auth.models import User
        request.user = User.objects.get(username='monitorius')

MIDDLEWARE_CLASSES.remove('common.middleware.yateamuser.YaTeamUserAuth')
MIDDLEWARE_CLASSES.append('local_settings.MyAuth')


Configuration().apply(globals())

# переопределяем настройки логирования, чтобы применить новый LOG_PATH
_format = '%(levelname)s %(asctime)s %(process)d %(name)s %(message)s'
_format_with_context = '%(levelname)s %(asctime)s %(context)s %(process)d %(name)s %(message)s'
LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'simple': {'format': _format},
        'context': {'format': _format_with_context},
        'exception': {
            '()': 'ylog.ExceptionFormatter',
            'format': _format,
            'full': True,
            'show_locals': True
        },
        'qloud_warnings': {
            '()': 'travel.rasp.library.python.common23.logging.qloud.QloudJsonFormatter',
            'tag': 'warnings'
        },
        'qloud_application': {
            '()': 'travel.rasp.library.python.common23.logging.qloud.QloudJsonFormatter',
            'tag': 'application'
        },
        'qloud_errors': {
            '()': 'travel.rasp.library.python.common23.logging.qloud.QloudExceptionFormatter',
            'add_request_info': False,
            'tag': 'errors'
        },
        'qloud_errors_request': {
            '()': 'travel.rasp.library.python.common23.logging.qloud.QloudExceptionFormatter',
            'add_request_info': True,
            'tag': 'errors'
        },
    },
    'filters': {
        'unique_warnings': {
            '()': 'travel.rasp.library.python.common23.logging.WarningFilterOnce'
        },
        'add_context': {
            '()': 'travel.rasp.library.python.common23.logging.AddContextFilter',
        },
        'add_context_dict': {
            '()': 'travel.rasp.library.python.common23.logging.AddContextFilter',
            'as_dict': True
        },
    },
    'handlers': {
        'application': {
            'filters': ['add_context'],
            'class': 'travel.rasp.library.python.common23.logging.WatchedFileHandler',
            'filename': os.path.join(LOG_PATH, 'application.log'),
            'formatter': 'context',
        },
        'warnings': {
            'class': 'travel.rasp.library.python.common23.logging.WatchedFileHandler',
            'filename': os.path.join(LOG_PATH, 'warnings.log'),
            'formatter': 'simple',
        },
        'exception': {
            'filters': ['add_context'],
            'class': 'travel.rasp.library.python.common23.logging.WatchedFileHandler',
            'filename': os.path.join(LOG_PATH, 'exception.log'),
            'formatter': 'exception',
            'level': 'ERROR',
        },
        'stdout_application': {
            'filters': ['add_context_dict'],
            'class': 'logging.StreamHandler',
            'stream': 'ext://sys.stdout',
            'formatter': 'qloud_application'
        },
        'stdout_warnings': {
            'class': 'logging.StreamHandler',
            'stream': 'ext://sys.stdout',
            'formatter': 'qloud_warnings',
        },
        'stderr': {
            'filters': ['add_context_dict'],
            'class': 'logging.StreamHandler',
            'stream': 'ext://sys.stderr',
            'formatter': 'qloud_errors',
            'level': 'ERROR',
        },
        'stderr_request': {
            'filters': ['add_context_dict'],
            'class': 'logging.StreamHandler',
            'stream': 'ext://sys.stderr',
            'formatter': 'qloud_errors_request',
            'level': 'ERROR',
        },
    },
    'loggers': {
        '': {
            'handlers': ['application', 'stdout_application'],
            'level': BASE_LOG_LEVEL,
        },
        'py.warnings': {
            'filters': ['unique_warnings'],
            'propagate': False,
            'handlers': ['warnings', 'stdout_warnings'],
            'level': BASE_LOG_LEVEL,
        },
        'django.request': {
            'handlers': ['exception', 'stderr_request'],
            'level': 'ERROR',
        },
    }
}


def stdoutlog():
    LOGGING['handlers']['stdout'] = {
        'class': 'logging.StreamHandler',
        'level': 'DEBUG',
    }

    LOGGING['loggers']['']['handlers'].append('stdout')
    LOGGING['loggers']['']['handlers'].remove('stdout_application')


stdoutlog()

