# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.contrib.admin import ModelAdmin
from django.contrib import admin

from common.models.geo import Station, Settlement, ExternalDirection
from common.models.teasers import Page


@admin.register(Station)
class StationAdmin(ModelAdmin):
    list_display = ('id', 'title', 'station_type', 'majority', 't_type', 'hidden')
    list_filter = ('majority', 'station_type', 'hidden', 't_type', 'suburban_zone')
    search_fields = ('title', 'title_en', 'code_set__code')


@admin.register(Settlement)
class SettlementAdmin(ModelAdmin):
    list_display = ('id', 'title_ru',)
    list_filter = ('hidden',)
    search_fields = ('title_ru', 'title_en')


@admin.register(ExternalDirection)
class ExternalDirectionAdmin(ModelAdmin):
    search_fields = ('title', 'code')
    list_filter = ('suburban_zone', )
    list_display = ('title', 'code')


@admin.register(Page)
class PageAdmin(ModelAdmin):
    list_display = ('title', 'code')
