# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
from datetime import timedelta

from django.conf import settings

from common.db.mongo import databases
from common.dynamic_settings.default import conf
from common.utils.lock import lock
from travel.rasp.library.python.common23.logging.scripts import script_context
from travel.rasp.info_center.info_center.scripts.utils import (
    SUBS_LOCK_DATABASE_NAME, get_today, log_script_execution, get_script_log_coll
)

log = logging.getLogger(__name__)


def run():
    with lock('clean_subscription_changes', timeout=600, database_name=SUBS_LOCK_DATABASE_NAME), \
            script_context('clean_subscription_changes'), \
            log_script_execution():
        try:
            old_date = get_today() - timedelta(days=conf.SUBURBAN_NOTIFY_OLD_DAYS - 1)

            databases[settings.SUBURBAN_NOTIFICATION_DATABASE_NAME].subscription_changes.remove({
                'calc_date': {'$lte': old_date}
            })

            get_script_log_coll().remove({'start_time': {'$lte': old_date}})

        except Exception:
            log.exception('clean_subscription_changes failed')


if __name__ == '__main__':
    run()
