# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import os

from datetime import timedelta

import yt.wrapper as yt
from django.conf import settings
from pymongo import DESCENDING

from travel.rasp.library.python.common23.data_api.juggler.juggler import CheckError, CRIT, get_events, send_events
from travel.rasp.library.python.common23.date.environment import now_utc
from travel.rasp.info_center.info_center.scripts.utils import get_script_log_coll
from travel.rasp.info_center.info_center.suburban_notify.send_pushes_yt import YT_PROXY

UPDATE_DELAY = timedelta(minutes=90)


def check_subs_changes_script():
    """ Проверяем, что каждый час запускается скрипт. """
    last_script = get_script_log_coll().find({'name': 'run_subscription_changes'}).sort('start_time', DESCENDING)[0]

    if not last_script or last_script['start_time'] + UPDATE_DELAY < now_utc() or last_script.get('fail'):
        raise CheckError(CRIT, 'Script not running every hour')


def check_send_pushes_yt():
    """ Проверяем, что для скрипта была создана таблица с пушами в Yt. """
    yt.update_config(
        {
            "token": settings.YT_TOKEN,
            "proxy": {'url': YT_PROXY}
        }
    )

    last_script = get_script_log_coll().find({'pushes.table_name': {'$exists': True}}).sort('end_time', DESCENDING)[0]

    table = last_script['pushes']['table_name'] if last_script else None

    if not table or not yt.exists(table):
        raise CheckError(CRIT, 'Pushes Yt table not exist')


def run():
    tags = ['infocenter', 'suburban-notification']
    checks_events = get_events([
        ('suburban-notification-subs-changes', check_subs_changes_script, tags),
        ('suburban-notification-send-pushes-yt', check_send_pushes_yt, tags)
    ])

    if 'SANDBOX_CONFIG' in os.environ:
        for event in checks_events:
            event.host = 'RaspInfocenterTask'

    send_events(checks_events)


if __name__ == '__main__':
    run()
