# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
from datetime import timedelta

from common.utils.lock import lock
from travel.rasp.library.python.common23.logging.scripts import script_context
from travel.rasp.info_center.info_center.scripts.utils import get_today, SUBS_CHANGES_LOCK, SUBS_LOCK_DATABASE_NAME, log_script_execution
from travel.rasp.info_center.info_center.suburban_notify.main import run_find_changes_for_hour

log = logging.getLogger(__name__)


def run():
    with lock(SUBS_CHANGES_LOCK, timeout=1700, database_name=SUBS_LOCK_DATABASE_NAME), \
            script_context('run_subscription_changes'), \
            log_script_execution():
        run_find_changes_for_hour(get_today() + timedelta(days=1), 19)


if __name__ == '__main__':
    run()
