# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import argparse
import logging
from datetime import datetime

from common.utils.lock import lock
from travel.rasp.library.python.common23.logging.scripts import script_context
from travel.rasp.info_center.info_center.scripts.utils import get_today, SUBS_CHANGES_LOCK, SUBS_LOCK_DATABASE_NAME
from travel.rasp.info_center.info_center.suburban_notify.main import run_find_changes

log = logging.getLogger(__name__)


def run():
    with lock(SUBS_CHANGES_LOCK, timeout=1700, database_name=SUBS_LOCK_DATABASE_NAME), \
            script_context('run_subscription_changes_manual'):
        parser = argparse.ArgumentParser()
        parser.add_argument('--date', default='')
        args = parser.parse_args()

        if args.date:
            date = datetime.strptime(args.date, '%Y-%m-%d')
        else:
            date = get_today()

        run_find_changes(date)


if __name__ == "__main__":
    run()
