# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from contextlib import contextmanager
from django.conf import settings
from pymongo import IndexModel, DESCENDING
from ylog.context import get_log_context

from common.db.mongo import databases
from travel.rasp.library.python.common23.date.environment import now_utc


SUBS_CHANGES_LOCK = 'run_subscription_changes'
SUBS_LOCK_DATABASE_NAME = settings.SUBURBAN_NOTIFICATION_DATABASE_NAME


def get_today():
    return now_utc().replace(hour=0, minute=0, second=0, microsecond=0)


def get_script_log_coll():
    return databases[settings.SUBURBAN_NOTIFICATION_DATABASE_NAME].script_log


def create_log_indexes():
    coll = get_script_log_coll()
    coll.create_indexes([
        IndexModel([('key', DESCENDING)], unique=True, background=True),
        IndexModel([('name', DESCENDING)], background=True),
        IndexModel([('end_time', DESCENDING)], background=True)
    ])


def update_one_script_log(data):
    coll = get_script_log_coll()

    coll.update_one(
        {'key': get_log_context().get('script_id')},
        {'$set': data},
        upsert=True
    )


@contextmanager
def log_script_execution():
    update_one_script_log({
        'start_time': now_utc(),
        'name': get_log_context()['script_name']
    })

    try:
        yield

    except Exception as ex:
        update_one_script_log({
            'fail': {
                'time': now_utc(),
                'error': repr(ex)
            },
            'end_time': now_utc()
        })
        raise

    update_one_script_log({'end_time': now_utc()})
