function addListElement(list, elCreator, creator_args) {
    var currentIndex = $(list).data('current_obj_id');
    if (currentIndex === undefined) {
        currentIndex = 0;
    }
    currentIndex += 1;
    var el = $(elCreator($(list).attr('id'), currentIndex, creator_args));
    var delButton = $('<a class="inline-deletelink"/>');
    delButton.on('click', function() {
        el.parent().remove();
    });

    var elContainer = $('<p>').append(delButton).append(el);
    list.append(elContainer);

    $(list).data('current_obj_id', currentIndex);
}


function addLinkedObjectListEl(container, objType, objKey, objTitle) {
    addListElement(container, createLinkedObjEl, [objType, objKey, objTitle]);

    // Копипаста из RelatedObjectLookups.js
    $('.related-lookup').click(function(e) {
        e.preventDefault();
        var event = $.Event('django:lookup-related');
        $(this).trigger(event);
        if (!event.isDefaultPrevented()) {
            showRelatedObjectLookupPopup(this);
        }
    });
}

function createLinkedObjEl(prefix, ind, args) {
    // Создаем элемент для работы с RelatedObjectLookups.js
    var objType = args[0];
    var objKey = args[1];
    var objTitle = args[2];

    if (objKey === undefined) {objKey = ''}
    if (objTitle === undefined) {objTitle = ''}

    var objName = prefix + '_' + objType + '_' + ind;

    return '<p id="' + 'id_container_' + objName + '">' +
        '<label for="id_' + objName + '">' + objType +'</label>' +
        '<input ' +
            'class="vForeignKeyRawIdAdminField" type="text" ' +
            'id="id_' + objName + '" ' +
            'name="' + objName + '" ' +
            'value="' + objKey + '" ' +
        '/>' +
        '<a href="/admin/www/' + objType + '/?_to_field=id" ' +
            'class="related-lookup" ' +
            'id="lookup_id_' + objName + '" ' +
            'title="Поиск" ' +
        '></a>' +
        '<strong>' + objTitle + '</strong>' +
    '</p>';
}

function addMessagesListEl(container, text, dtCreated) {
    addListElement(container, createMessageEl, [text, dtCreated]);
}

function createMessageEl(prefix, ind, args) {
    var text = args[0];
    var dtCreated = args[1];

    if (text === undefined) {text = ''}
    if (dtCreated === undefined) {dtCreated = ''}

    var name = prefix + '_' + ind;

    return '<p id="' + 'id_container_' + name + '">' +
        '<h3>Сообщение ленты</h3>' +
        '<p style="display: inline">' +
            '<input name="' + name + '_dtCreated" value="' + dtCreated + '">' +
        '</p>' +
        '<textarea name="' + name + '_text" rows="5" cols="100">' + text + '</textarea>' +
        '<hr><br>' +
    '</p>';
}

function addPushEl(container, push) {
    function fieldEl(title, value) {
        return'<p>' +
            '<label>' + title + '</label> ' +
            '<pre style="white-space:pre-wrap; word-wrap:break-word; overflow-x: auto">' + value + '</pre>' +
        '</p>';
    }

    var title = '<h3>Пуш</h3>';
    var errorsEl = '';
    if (push.error) {
        title = '<h3 style="color: red">Пуш не отправлен</h3>';
        errorsEl = fieldEl('Ошибки', push.error);
    }

    var elPush = '<p>' +
        title +
        fieldEl('Создан', push.dtCreated) +
        fieldEl('Заголовок', push.title) +
        fieldEl('Текст', push.text) +
        fieldEl('Урл', push.url) +
        fieldEl('Урл картинки', push.imageUrl) +
        fieldEl('Политика', push.policy) +
        errorsEl +
        '<hr><br>' +
    '</p>';

    container.append(elPush);
}

function addYadmNewsItemEl(container, yadmNewsItem) {
    function fieldEl(title, value) {
        return'<p>' +
            '<label>' + title + '</label> ' +
            '<pre style="white-space:pre-wrap; word-wrap:break-word; overflow-x: auto">' + value + '</pre>' +
        '</p>';
    }

    var title = '<h3>Новость для ЯдМ</h3>';

    var elYadmNewsItem = '<p>' +
        title +
        fieldEl('Id', yadmNewsItem.id) +
        fieldEl('Создана', yadmNewsItem.dtCreated) +
        fieldEl('Заголовок', yadmNewsItem.title) +
        fieldEl('Текст', yadmNewsItem.text) +
        fieldEl('Важность', yadmNewsItem.importance) +
        '<hr><br>' +
    '</p>';

    container.append(elYadmNewsItem);
}

function regenerateUuid(field) {
    $.ajax({
        url: '/admin/info/gen_uid/',
        type: 'GET',
        success: function(response) {
            field.val(response['value']);
        }
    });
}
