# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings
from mongoengine import DynamicField, DoesNotExist

from common.db.mongo.base import RaspDocument


class NotifyParams(RaspDocument):
    key = DynamicField(required=True)
    value = DynamicField(required=True)

    meta = {
        'indexes': ['key'],
        'index_background': True,
        'strict': False,
        'db_alias': settings.SUBURBAN_NOTIFICATION_DATABASE_NAME
    }

    @classmethod
    def get_param(cls, key):
        try:
            doc = cls.objects.get(key=key)
        except DoesNotExist:
            return None

        return doc.value

    @classmethod
    def set_param(cls, key, value):
        return cls.objects(key=key).upsert_one(value=value)

    @classmethod
    def update_value(cls, key, path, value):
        return cls.objects(key=key).update_one(__raw__={'$set': {'value.{}'.format(path): value}})
