# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings
from django.conf.urls import include, url
from django.conf.urls.static import static
from django.contrib import admin

from common.settings.utils import define_setting
from travel.rasp.info_center.info_center.views.yadm_news import yadm_news
from travel.rasp.info_center.info_center.views.admin import (
    InfoView, info_remove, info_raw, info_list, info_add, send_push, gen_info_uid, add_yadm_news_item
)
from travel.rasp.info_center.info_center.views.api import ping, env, get_info_view, deploy_hook
from travel.rasp.info_center.info_center.views.subscriptions import (
    modify_subscription, delete_subscription, get_subscription, get_subsciption_changes, get_changes,
    get_all_subscriptions
)


define_setting('ENABLE_INTERNAL_HANDLES', default=False)


urlpatterns = [
    # системные ручки
    url(r'^ping/?', ping),
    # подписки
    url(r'^subscription/modify/?$', modify_subscription),
    url(r'^subscription/delete/?$', delete_subscription),
    url(r'^subscription/get/?$', get_subscription),
    url(r'^subscription/changes/?$', get_changes),
    url(r'^subscription/get_all/?$', get_all_subscriptions)
]


if settings.ENABLE_INTERNAL_HANDLES:
    urlpatterns = [
        # системные ручки
        url(r'^env/?', env),
        url(r'^deployhook/?', deploy_hook),

        # апи инфоцентра
        url(r'^api/get_info/?', get_info_view),

        # админка инфоцентра
        url(r'^admin/info/?$', info_list, name='info_list'),
        url(r'^admin/info/add/?$', info_add, name='info_add'),
        url(r'^admin/info/gen_uid/?$', gen_info_uid, name='gen_info_uid'),
        url(r'^admin/info/(\d+)/?$', InfoView.as_view(), name='info_obj'),
        url(r'^admin/info/(\d+)/change/?$', InfoView.as_view(), name='info_change'),
        url(r'^admin/info/(\d+)/remove/?$', info_remove, name='info_remove'),
        url(r'^admin/info/(\d+)/raw/?$', info_raw, name='info_obj_raw'),
        url(r'^admin/info/(\d+)/send_push/?$', send_push, name='info_send_push'),
        url(r'^admin/info/(\d+)/add_yadm_news_item/?$', add_yadm_news_item, name='info_add_yadm_news_item'),

        # заменяем топлевел пути админки на info_list, но оставляем остальные
        url(r'^$', info_list, name='info_list'),
        url(r'^admin/?$', info_list, name='info_list'),
        url(r'', include(admin.site.urls)),
        url(r'^admin/', include(admin.site.urls)),

        # подписки
        url(r'^subscription/dev/get_changes/?$', get_subsciption_changes),

        # передача в ЯдМ
        url(r'^yadm_news/?$', yadm_news, name='yadm_news'),
    ] + urlpatterns


if settings.DEBUG:
    import debug_toolbar

    urlpatterns = (
        [url(r'^__debug__/', include(debug_toolbar.urls))] +
        static(settings.STATIC_URL, document_root=settings.STATIC_ROOT) +
        urlpatterns
    )
