# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings
from django.contrib.admin.widgets import AdminDateWidget
from django.forms import widgets
from django import forms

from common.apps.info_center.models import Info, Push
from travel.rasp.library.python.common23.date import environment
from travel.rasp.info_center.info_center.views.deprecated_widgets import CheckboxFieldRenderer


class CheckboxFieldRendererHorizontal(CheckboxFieldRenderer):
    inner_html = '<li style="display: inline;">{choice_value}{sub_widgets}</li>'


class CheckboxSelectMultipleHorizontal(forms.CheckboxSelectMultiple):
    renderer = CheckboxFieldRendererHorizontal


class InfoForm(forms.Form):
    title = forms.CharField(label='Заголовок', max_length=100)
    url = forms.CharField(label='Ссылка заголовка', required=False)
    text = forms.CharField(label='Текст', widget=forms.Textarea({'rows': 10, 'cols': 100}))
    text_short = forms.CharField(
        label='Короткий текст', widget=forms.Textarea({'rows': 4, 'cols': 100}), required=False)
    info_type = forms.ChoiceField(label='Тип', choices=Info.info_type.choices, initial='ahtung')
    lang = forms.ChoiceField(label='Язык', choices=settings.LANGUAGES, initial='ru')
    national_versions = forms.MultipleChoiceField(
        label='Национальные версии',
        choices=settings.DOMAIN_TO_NATIONAL_VERSION.items(),
        initial=['ru'],
        widget=CheckboxSelectMultipleHorizontal()
    )
    importance = forms.IntegerField(label='Важность', initial=0)
    dt_from = forms.DateField(label='Дата начала кампании', widget=AdminDateWidget, initial=lambda: environment.now())
    dt_to = forms.DateField(label='Дата окончания кампании', widget=AdminDateWidget, initial=lambda: environment.now())
    info_url = forms.CharField(label='Ссылка на это Info', required=False)
    services = forms.MultipleChoiceField(
        label='Сервисы',
        choices=((Info.Service.WEB, u'web'), (Info.Service.MOBILE_APPS, u'mobile apps')),
        widget=CheckboxSelectMultipleHorizontal(),
        required=False
    )
    uuid = forms.CharField(label='uid64', widget=widgets.TextInput(attrs={'readonly': True}))


class PushForm(forms.Form):
    title = forms.CharField(label='Заголовок', max_length=100)
    text = forms.CharField(label='Текст', widget=forms.Textarea({'rows': 10, 'cols': 100}))
    url = forms.CharField(
        label='Ссылка по клику на пуш', required=False,
        initial='yandextrains://favourites'
    )
    image_url = forms.CharField(
        label='Ссылка на картинку (mds)', required=False
    )
    policy = forms.ChoiceField(label='Политика пуша', choices=Push.POLICIES, initial=Push.POLICIES[0][0])


class YadmNewsItemForm(forms.Form):
    title = forms.CharField(label='Заголовок', max_length=200)
    text = forms.CharField(label='Текст', widget=forms.Textarea({'rows': 10, 'cols': 100}))
    importance = forms.IntegerField(label='Важность', initial=0, required=False)
