PY2_LIBRARY()

OWNER(
    g:rasp-back
)

PEERDIR(
    contrib/python/ipython
    contrib/python/APScheduler
    contrib/python/django-debug-toolbar
    contrib/python/Flask

    library/python/python-django-yauth

    travel/library/python/tracing/django
    travel/library/python/tracing/gunicorn
    travel/library/python/tracing/instrumentation
    travel/library/python/entrypoint

    travel/rasp/library/python/api_clients/sup
    travel/rasp/library/python/geosearch
    travel/rasp/library/python/common
    travel/rasp/library/python/route_search
    travel/rasp/library/python/tracing

    yt/python/client
)

PY_SRCS(
    app.py
    docker/local_settings.py
    gunicorn_conf.py
    settings.py
    tests_settings.py
    wsgi.py

    info_center/__init__.py
    info_center/admin.py
    info_center/app.py
    info_center/scripts/__init__.py
    info_center/scripts/clean_subscription_changes.py
    info_center/scripts/monitoring/__init__.py
    info_center/scripts/monitoring/notification.py
    info_center/scripts/run_subscription_changes.py
    info_center/scripts/run_subscription_changes_after_prepare_all.py
    info_center/scripts/run_subscription_changes_manual.py
    info_center/scripts/utils.py
    info_center/suburban_notify/__init__.py
    info_center/suburban_notify/changes/__init__.py
    info_center/suburban_notify/changes/changes_finder.py
    info_center/suburban_notify/changes/find.py
    info_center/suburban_notify/changes/models.py
    info_center/suburban_notify/changes/text.py
    info_center/suburban_notify/db.py
    info_center/suburban_notify/main.py
    info_center/suburban_notify/notify_params.py
    info_center/suburban_notify/search.py
    info_center/suburban_notify/send_pushes_yt.py
    info_center/suburban_notify/subscriptions/__init__.py
    info_center/suburban_notify/subscriptions/filters.py
    info_center/suburban_notify/subscriptions/models.py
    info_center/suburban_notify/utils.py
    info_center/urls.py
    info_center/views/__init__.py
    info_center/views/admin.py
    info_center/views/api.py
    info_center/views/deprecated_widgets.py
    info_center/views/forms.py
    info_center/views/subscriptions.py
    info_center/views/yadm_news.py
)

RESOURCE_FILES( PREFIX travel/rasp/info_center/
    info_center/templates/info_center.html
    info_center/templates/info_center_list.html

    info_center/static/info_center/info_center.js
)


END()

RECURSE(
    bin
)

RECURSE_FOR_TESTS(
    tests
    bin/tests
)
