# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from requests import Session
from requests.adapters import HTTPAdapter
from urllib3.util.retry import Retry


def get_retriable_session(total=3, backoff_factor=0.5):
    session = Session()
    retries = Retry(total=total, backoff_factor=backoff_factor)
    adapter = HTTPAdapter(max_retries=retries)
    session.mount('http://', adapter)
    session.mount('https://', adapter)
    return session
