# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging

from travel.rasp.infra.api.base.api_base import ApiBase, ApiException


logger = logging.getLogger(__name__)


class CalendarApiException(ApiException):
    pass


class CalendarApi(ApiBase):
    API_URL = "http://calendar-api.tools.yandex.net"

    def get_events(self, layer, date_from, date_to):
        return self._make_json_request(
            "get",
            self.API_URL + "/internal/get_events.json?",
            params={"tz": "Europe/Moscow", "layerId": layer, "from": date_from, "to": date_to},
        )

    def create_event(self, name, layer, start, end, attendees, notifications_channel, notifications_offset, robot_uid):
        event = {
            "name": name,
            "layerId": layer,
            "startTs": start,
            "endTs": end,
            "attendees": attendees,
            "notifications": [{"channel": notifications_channel, "offset": notifications_offset}],
            "participantsCanInvite": "true",
            "participantsCanEdit": "true",
            "othersCanView": "true",
        }

        logger.info("Creating event: %s", event)
        result = self._make_json_request(
            "post", self.API_URL + "/internal/create-event?", params={"uid": robot_uid}, json=event
        )
        if result.get("status") != "ok":
            raise CalendarApiException(result)
        return result
