# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from collections import namedtuple

from travel.rasp.infra.api.base.api_base import ApiBase


Gaps = namedtuple('Gaps', 'login, date_from, date_to')


class GapApi(ApiBase):
    API_URL = 'https://staff.yandex-team.ru'

    def get_gaps_by_login(self, login, date_from, date_to):
        response = self._make_json_request(
            'get',
            self.API_URL + '/gap-api/api/gaps_find/',
            params={
                'date_from': date_from,
                'date_to': date_to,
                'person_login': [login]
            }
        )

        return [Gaps(
            login=str(gap['person_login']),
            date_from=gap['date_from'],
            date_to=gap['date_to'],
        ) for gap in response['gaps']]
