# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from travel.rasp.infra.api.base.api_base import ApiBase


class SolomonApi(ApiBase):
    URL = 'http://solomon.yandex.net/api/v2/'

    def __init__(self, oauth_token=None, project='rasp'):
        super(SolomonApi, self).__init__(oauth_token=oauth_token)
        self.project = project

    def get_alert(self, alert_id):
        url = self.URL + 'projects/{}/alerts/{}'.format(self.project, alert_id)
        return self._make_json_request('get', url)

    def update_alert(self, alert_id, alert_data):
        url = self.URL + 'projects/{}/alerts/{}'.format(self.project, alert_id)
        return self._make_json_request('put', url, json=alert_data)

    def create_alert(self, alert_data):
        url = self.URL + 'projects/{}/alerts'.format(self.project)
        return self._make_json_request('post', url, json=alert_data)

    def delete_alert(self, alert_id):
        url = self.URL + 'projects/{}/alerts/{}'.format(self.project, alert_id)
        return self._make_raw_request('delete', url)

    def list_alerts(self, **kwargs):
        url = self.URL + 'projects/{}/alerts'.format(self.project)
        return self._make_json_request('get', url, params=kwargs)

    def get_active_alerts_ids(self):
        return {item['id'] for item in self.list_alerts(filterByStates='ACTIVE', pageSize=10000).get('items', [])}
