# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import re

from travel.rasp.infra.api.base.api_base import ApiBase


class StaffApi(ApiBase):
    API_URL = 'https://staff-api.yandex-team.ru'

    def get_person_phone(self, login, work_phone=True):
        response = self._make_json_request(
            'get',
            self.API_URL + '/v3/persons?',
            params={
                '_fields': 'work_phone' if work_phone else 'phones.number',
                'login': login
            }
        )
        result = response['result'][0]
        if work_phone:
            phone = str(result['work_phone'])
        else:
            phone = result['phones'][0]['number']
            phone = re.sub(r'[^+\d+]', '', phone)
        return phone
