# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import tarfile

from travel.rasp.library.python.shell_utils import logged_check_call

MARKUP_PATH = 'markup.tar'
BUILD_LOG_PATH = 'build.log'


def build_markup(version):
    logged_check_call('./docker/build_static.sh > {}'.format(BUILD_LOG_PATH))

    with open('version', 'w') as f:
        f.write(version)


def pack_markup():
    with tarfile.open(MARKUP_PATH, 'w') as tar:
        tar.add('static')
        tar.add('version')
