# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import tarfile

from retry import retry

from travel.rasp.library.python.shell_utils import logged_check_call, cd


@retry(tries=3, delay=3)
def upload_to_s3(aws_url, aws_bucket, app_prefix):
    logged_check_call('aws s3 --endpoint-url={aws_url} sync ./morda/markup/ s3://{aws_bucket}/{app_prefix}/'.format(
        aws_url=aws_url,
        aws_bucket=aws_bucket,
        app_prefix=app_prefix
    ))


def build_markup(version):
    with cd('morda/markup'):
        logged_check_call('nvm use 0.10', skip_on_err=True)
        logged_check_call('YENV=production make build > build.log', skip_on_err=True)

    with cd('morda/markup/lego/tools'):
        logged_check_call('rm -rf node_modules')
        logged_check_call('npm install --registry=http://npm.yandex-team.ru', skip_on_err=True)

    with cd('morda/markup'):
        logged_check_call('YENV=production make rebuild > rebuild.log')
        with open('version', 'w') as f:
            f.write(version)


def pack_markup():
    with tarfile.open('markup.tar', 'w') as tar:
        tar.add('morda/markup')
