# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import argparse
import logging
import sys

from travel.rasp.infra.tasks.update_touch_markup import build_markup, upload_to_s3


def setup_logger():
    root = logging.getLogger()
    root.setLevel(logging.DEBUG)

    handler = logging.StreamHandler(sys.stdout)
    handler.setLevel(logging.DEBUG)
    formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
    handler.setFormatter(formatter)
    root.addHandler(handler)


def main():
    setup_logger()
    parser = argparse.ArgumentParser()
    parser.add_argument('--url', type=str, default='https://s3.mds.yandex.net')
    parser.add_argument('--bucket', type=str, default='rasp')
    parser.add_argument('--prefix', type=str, default='s/touch')
    parser.add_argument('--version', type=str, default='test-version')
    args = parser.parse_args()
    build_markup(version=args.version)
    upload_to_s3(aws_url=args.url, aws_bucket=args.bucket, app_prefix=args.prefix)


if __name__ == '__main__':
    main()
